'use client';

import Header from '../../../components/Header';
import MobileHeader from '../../../components/MobileHeader';
import Footer from '../../../components/Footer';
import { useTranslations } from 'next-intl';
import { useState, useEffect } from 'react';
import Image from 'next/image';

export default function TermsOfUsePage() {
  const t = useTranslations('TermsOfUsePage');
  const [isDesktop, setIsDesktop] = useState(false);

  useEffect(() => {
    const checkScreenSize = () => {
      setIsDesktop(window.innerWidth >= 1024);
    };

    checkScreenSize();
    window.addEventListener('resize', checkScreenSize);

    return () => window.removeEventListener('resize', checkScreenSize);
  }, []);

  if (isDesktop) {
    // Desktop Version
    return (
      <div className="flex w-full flex-col items-center bg-[#F5F1F0] font-roboto">
        {/* Header */}
        <div className="flex h-[65px] px-8 justify-between items-center w-full bg-white">
          <Header />
        </div>

        {/* Title Section */}
        <div className="flex h-[146px] px-8 py-[50px] justify-center items-center gap-2 w-full bg-[#F5F1F0]">
          <div className="flex-1 text-[#1C1C1C] text-center font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]">
            {t('title')}
          </div>
        </div>

        {/* Content Section */}
        <div className="flex w-full px-8 pb-[60px] flex-col items-center opacity-75">
          <div className="w-full text-black font-roboto text-[18px] font-light leading-[150%] whitespace-pre-line">
            {t('content')}
          </div>
        </div>

        <Footer />
      </div>
    );
  }

  // Mobile Version (351px)
  return (
    <div className="flex w-full flex-col items-center bg-[#F5F1F0] font-roboto">
      {/* Mobile Header */}
      <div className="flex h-[65px] px-8 justify-between items-center w-full bg-white">
        <MobileHeader />
      </div>

      {/* Mobile Title Section */}
      <div className="flex h-[146px] px-8 py-[50px] justify-center items-center gap-2 w-full bg-[#F5F1F0]">
        <div className="flex-1 text-[#1C1C1C] text-center font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]">
          Tearms of Use
        </div>
      </div>

      {/* Mobile Content Section */}
      <div className="flex max-w-[1376px] px-3 pb-[60px] flex-col items-end w-full opacity-75">
        <div className="w-full text-black font-roboto text-[18px] font-light leading-[150%] whitespace-pre-line">
          {t('content')}
        </div>
      </div>

      <Footer />
    </div>
  );
} 